/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jsonthings.item;

import dev.gigaherz.jsonthings.things.IFlexItem;
import dev.gigaherz.jsonthings.things.StackContext;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.IItemRenderProperties;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.client.TravelersGearModel;
import slimeknights.tconstruct.tools.data.material.MaterialIds;

public class FlexFlatEmbellishedArmor
extends ModifiableArmorItem
implements IFlexItem {
    private final Map<String, String> ARMOR_TEXTURE_CACHE = new HashMap<String, String>();
    private final Map<String, String> LEG_TEXTURE_CACHE = new HashMap<String, String>();
    private final Function<String, String> ARMOR_GETTER = mat -> this.makeArmorTexture((String)mat, "layer_1");
    private final Function<String, String> LEG_GETTER = mat -> this.makeArmorTexture((String)mat, "layer_2");
    private final Map<String, FlexEventHandler> eventHandlers = new HashMap<String, FlexEventHandler>();
    private final Set<CreativeModeTab> tabs = new HashSet<CreativeModeTab>();
    private final ResourceLocation name;
    private final MaterialId defaultMaterial;
    private final boolean dyeable;

    public FlexFlatEmbellishedArmor(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builderIn, ToolDefinition toolDefinition, ResourceLocation name, MaterialId defaultMaterial, boolean dyeable) {
        super(materialIn, slot, builderIn, toolDefinition);
        this.name = name;
        this.defaultMaterial = defaultMaterial;
        this.dyeable = dyeable;
    }

    private String makeArmorTexture(String material, String texture) {
        ResourceLocation location = ResourceLocation.m_135820_((String)material);
        if (location == null) {
            location = this.defaultMaterial;
        }
        return String.format("%s:textures/models/armor/%s/%s_%s_%s.png", this.name.m_135827_(), this.name.m_135815_(), texture, location.m_135827_(), location.m_135815_());
    }

    private String getMaterial(ItemStack stack) {
        if (ModifierUtil.getModifierLevel(stack, TinkerModifiers.golden.getId()) > 0) {
            return MaterialIds.gold.toString();
        }
        String key = ModifierUtil.getPersistentString(stack, TinkerModifiers.embellishment.getId());
        if (key.isEmpty()) {
            return this.defaultMaterial.toString();
        }
        return key;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        String material = this.getMaterial(stack);
        if (slot == EquipmentSlot.LEGS) {
            return this.LEG_TEXTURE_CACHE.computeIfAbsent(material, this.LEG_GETTER);
        }
        return this.ARMOR_TEXTURE_CACHE.computeIfAbsent(material, this.ARMOR_GETTER);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            @Nonnull
            public Model getBaseArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                if (FlexFlatEmbellishedArmor.this.dyeable) {
                    return TravelersGearModel.getModel(itemStack, armorSlot, _default, FlexFlatEmbellishedArmor.this.name, true);
                }
                return _default;
            }
        });
    }

    public void addCreativeStack(StackContext stackContext, Iterable<CreativeModeTab> tabs) {
        for (CreativeModeTab tab : tabs) {
            this.tabs.add(tab);
        }
    }

    protected boolean m_41389_(CreativeModeTab category) {
        return this.tabs.contains(category);
    }

    public void addEventHandler(String name, FlexEventHandler flexEventHandler) {
        this.eventHandlers.put(name, flexEventHandler);
    }

    @Nullable
    public FlexEventHandler getEventHandler(String name) {
        return this.eventHandlers.get(name);
    }
}

